/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.SimpleSourceViewerConfiguration;
import com.aptana.editor.common.TextUtils;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.css.CSSSourceConfiguration;
import com.aptana.editor.html.HTMLDoubleClickStrategy;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.js.JSSourceConfiguration;
import com.aptana.editor.svg.SVGSourceConfiguration;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class HTMLSourceViewerConfiguration
extends SimpleSourceViewerConfiguration {
    private HTMLDoubleClickStrategy fDoubleClickStrategy;

    public HTMLSourceViewerConfiguration(IPreferenceStore preferences, AbstractThemeableEditor editor) {
        super(preferences, editor);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return TextUtils.combine((String[][])new String[][]{{"__dftl_partition_content_type"}, HTMLSourceConfiguration.CONTENT_TYPES, JSSourceConfiguration.CONTENT_TYPES, CSSSourceConfiguration.CONTENT_TYPES, SVGSourceConfiguration.CONTENT_TYPES});
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("com.aptana.editor.html", this.getEditor());
        return targets;
    }

    public ISourceViewerConfiguration getSourceViewerConfiguration() {
        return HTMLSourceConfiguration.getDefault();
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new RubyRegexpAutoIndentStrategy(contentType, (SourceViewerConfiguration)this, sourceViewer, HTMLPlugin.getDefault().getPreferenceStore())};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new HTMLDoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }
}

